* This file generates CPS NLF disability data from the CPS microdata.
* The rest of the data for Figure 6 are public SSDI data.

set more off
use /mcr/cps/matched/data/matched.dta, clear

drop if mlr==-1 | mlr==.

collapse (sum) sswgt, by(mdate mlr)
gen wgt=sswgt/(1000)
drop sswgt

reshape wide wgt, i(mdate) j(mlr)

gen pop  = wgt1+wgt2+wgt3+wgt4+wgt5+wgt6+wgt7
gen dis  = wgt6
gen dis_r= dis/pop

drop wgt*

export excel using fig6.xlsx, sheet("CPS_NLF_Disability") date(%tm) firstrow(variables)  
